/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers.keymapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import journeymap.api.services.Services;
import journeymap.client.event.handlers.KeybindingHandler;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class KeyRegistrationWrapper {
    private static final class_304.class_11900 CATEGORY_FULLSCREEN = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"journeymap", (String)"hotkeys_keybinding_fullscreen_category"));
    private static final class_304.class_11900 CATEGORY_JOURNEYMAP = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"journeymap", (String)"hotkeys_keybinding_category"));
    private final int keyCode;
    private final int fabricKeyCode;
    private final String description;
    private final Context context;
    private final Modifier modifier;
    private final Runnable action;
    private final Map<Class<? extends class_437>, ScreenAction> screenBindings;
    private class_304 keyBinding;

    private KeyRegistrationWrapper(Builder builder) {
        this.keyCode = builder.keyCode;
        this.description = builder.description;
        this.context = builder.context;
        this.modifier = builder.modifier;
        this.action = builder.action;
        this.screenBindings = builder.screenBindings;
        this.fabricKeyCode = builder.fabricKeyCode == null ? builder.keyCode : builder.fabricKeyCode;
    }

    public static Builder builder(String description, Context context, int keyCode) {
        return new Builder(description, context, keyCode);
    }

    public static Builder builder(String description, Context context) {
        return new Builder(description, context, -1);
    }

    public boolean matches(class_11907 event) {
        if (event instanceof class_11908) {
            class_11908 keyEvent = (class_11908)event;
            if (this.modifier != Modifier.NONE) {
                return Services.CLIENT_SERVICE.screenKeyPressedModifier(this.getKeyBinding(), keyEvent);
            }
            return this.getKeyBinding().method_1417(keyEvent);
        }
        if (event instanceof class_11909) {
            class_11909 mouseEvent = (class_11909)event;
            return this.getKeyBinding().method_1433(mouseEvent);
        }
        return false;
    }

    @Nullable
    public class_304 getKeyBinding() {
        return this.keyBinding;
    }

    public void setKeyBinding(class_304 keyBinding) {
        this.keyBinding = keyBinding;
    }

    public Map<Class<? extends class_437>, ScreenAction> getScreenBindings() {
        return this.screenBindings;
    }

    public int keyCode() {
        return this.keyCode;
    }

    public String description() {
        return this.description;
    }

    public class_304.class_11900 category() {
        return this.context == Context.GUI ? CATEGORY_FULLSCREEN : CATEGORY_JOURNEYMAP;
    }

    public Context context() {
        return this.context;
    }

    public int fabricKeyCode() {
        return this.fabricKeyCode;
    }

    public Modifier modifier() {
        return this.modifier;
    }

    public Runnable action() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KeyRegistrationWrapper that = (KeyRegistrationWrapper)obj;
        return this.keyCode == that.keyCode && Objects.equals(this.description, that.description) && Objects.equals((Object)this.context, (Object)that.context) && Objects.equals((Object)this.modifier, (Object)that.modifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyCode, this.description, this.context, this.modifier, this.action});
    }

    public String toString() {
        return "KeyRegistrationWrapper[keyCode=" + this.keyCode + ", description=" + this.description + ", category=" + String.valueOf(this.category()) + ", context=" + String.valueOf((Object)this.context) + ", modifier=" + String.valueOf((Object)this.modifier) + ", action=" + String.valueOf(this.action) + "]";
    }

    public static class Builder {
        private final int keyCode;
        private final String description;
        private final Context context;
        private Modifier modifier = Modifier.NONE;
        private Runnable action;
        private Integer fabricKeyCode;
        private final Map<Class<? extends class_437>, ScreenAction> screenBindings = new HashMap<Class<? extends class_437>, ScreenAction>();

        private Builder(String description, Context context, int keyCode) {
            this.description = description;
            this.keyCode = keyCode;
            this.context = context;
        }

        public Builder withFabricKeyCode(int keyCode) {
            this.fabricKeyCode = keyCode;
            return this;
        }

        public Builder withModifier(Modifier modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder withAction(Runnable action) {
            this.action = action;
            return this;
        }

        public Builder addScreenAction(Class<? extends class_437> screen, Runnable action) {
            this.screenBindings.put(screen, new ScreenAction(screen, action));
            return this;
        }

        public Builder addScreenAction(Class<? extends class_437> screen, Supplier<Boolean> conditional, Runnable action) {
            this.screenBindings.put(screen, new ScreenAction(screen, conditional, action));
            return this;
        }

        public KeyRegistrationWrapper register() {
            if ((Context.UNIVERSAL == this.context || Context.GUI == this.context) && this.screenBindings.isEmpty()) {
                throw new IllegalStateException("No screen bindings registered for keybinding " + this.description);
            }
            if ((Context.UNIVERSAL == this.context || Context.IN_GAME == this.context) && this.action == null) {
                throw new IllegalStateException("No action registered for keybinding " + this.description);
            }
            return KeybindingHandler.getInstance().register(new KeyRegistrationWrapper(this));
        }
    }

    public static enum Context {
        IN_GAME,
        GUI,
        UNIVERSAL;

    }

    public static enum Modifier {
        NONE,
        SHIFT,
        CTRL,
        ALT;

    }

    public record ScreenAction(Class<? extends class_437> screen, Supplier<Boolean> conditional, Runnable action) {
        public ScreenAction(Class<? extends class_437> screen, Runnable action) {
            this(screen, () -> true, action);
        }

        public boolean run() {
            if (this.conditional.get().booleanValue()) {
                this.action.run();
                return true;
            }
            return false;
        }
    }
}

